//Estas funciones se incrustan una vez, y sirven para crear, modificar borrar y seleccionar direcciones de envío
function mostrarModificarDireccionEnvio(elemento_boton){
	if (elemento_boton != null){
		//Vamos a identificar la capa desde la que se está ejecutando
		var elemento = $(elemento_boton.closest("div.muestra_direccion_envio_perso"));
		elemento.find('.botones_mod_borrar_direccion_envio').hide('fast');
		elemento.find("input[type='text']").removeAttr('readonly');
		elemento.find("input[disabled]").prop( "disabled", false );
		elemento.find("textarea").removeAttr('readonly');
		elemento.find('.guardar_modificaciones_direccion_envio').show('fast');
		//Vamos a poner el foco en el primer elemento:
		elemento.find("textarea, input[type='text']").first().select();
	}
}

function cancelarModificaDireccionEnvio(elemento_boton){
	var elemento = $(elemento_boton.closest("div.muestra_direccion_envio_perso"));
	elemento.find('.guardar_modificaciones_direccion_envio').hide('fast');
	elemento.find("input[type='text']").prop('readonly', true);
	elemento.find("textarea").prop('readonly', true);
	elemento.find('.botones_mod_borrar_direccion_envio').show('fast');	
}

function borrarDireccionenvio(elemento_boton, cliente){
	var elemento = $(elemento_boton.closest("div.muestra_direccion_envio_perso"));
	var codigo = elemento.find("input[name='mod_codigo']").prop("value");
	//Borramos la direccion de la lista
	//traduccion
	if (confirm('¿Está seguro de que desea eliminar esta dirección?')){
		var parametros = "codigo=" + codigo + "&cliente=" + cliente + "&accion=borrar";
		var url = shopUrl + "comunes/consultas/crea_mod_direccion_envio.php";
		realizar_solicitud(url, parametros, function(respuesta){
			//console.log(respuesta);
			if (respuesta == "BORRADA"){
				//Vamos a tener en cuenta que el elemento esté dentro de "linea lista...."
				var elemento_linea = elemento.closest(".linea_lista_direcciones_envio_perso");
				//Primero borramos el elemento interno y después el externo si lo hubiese
				elemento.remove();
				if (elemento_linea != null){
					elemento_linea.remove();
					location.reload();
				}
			}
		});
	}	
}

function seleccionarDireccionEnvio(elemento_boton, usuario, codigo_direccion, fichero_perso){
	var elemento = getLastHtmlObject();
	//console.log(elemento_boton, usuario, codigo_direccion, fichero_perso);
	var parametros = "codigo=" + codigo_direccion + "&cliente=" + usuario + "" + "&fichero_perso=" + fichero_perso;
	var url = shopUrl + "comunes/consultas/predeterminar_direccion_envio.php";
	realizar_solicitud(url, parametros, function(respuesta){
		//la respuesta lleva los valores separados por pipe "|"
		respuesta = respuesta.split("|");
		//console.log(respuesta);
		if (respuesta[0] == "CORRECTO"){
			//Lo primero es poner como predeterminada la que se ha marcado
			$("#direc_predeterminada").removeAttr("id");
			//Ahora predeterminamos la que nos han pasado en código
			elemento.parents(".linea_lista_direcciones_envio_perso").attr("id", "direc_predeterminada");
			//Lo segundo es modificar la predeterminada que aparece
			$(".muestra_datos_dir_predeterminada_perso").html($(respuesta[1]).html());
		}
	});	
}

function modificaDireccionEnvio(elemento_boton, cliente){
	var correcto = true;
	var elemento = $(elemento_boton.closest("div.muestra_direccion_envio_perso"));
	var formulario = elemento.find("form[action='" + shopUrl + "comunes/consultas/crea_mod_direccion_envio.php']");
	//Controlamos que los campos requeridos se hayan introducido:
	correcto = true;
	//Comrobaciones sólo para IE y resto de navegadores que no sean chrome o firefox
	var lista_input =  $(formulario).children("[required]");
	var total = lista_input.length;
	for (var i = 0;(i < total) && (correcto); i++){
		var elemento_lista = lista_input[i];
		if ($(elemento_lista).val() == ""){
			correcto = false;
			$(elemento_lista).focus();
			poner_sombra($(elemento_lista));
		}
	}
	//Si todo está correcto, continuamos, vamos a coger los valores
	if (correcto){
		var codigo = formulario.find("input[name='mod_codigo']").val();
		var accion = "modificar";
		//Vamos a recoger los valores del formulario en el orden en el que están
		var formParams = "";
		formulario.find("textarea[name^='campo_direccion_']").each(function(){
			//en el atributo name tenemos el nombre del campo
			var nombre = $(this).attr("name").replace("campo_direccion_", "") + "[]";
			//var nombre = $(this).attr("name").split("campo_direccion_")[0];
			var valor = $(this).val();
			formParams += "&" + nombre + "=" + valor;
		});
		formulario.find("input[name^='campo_direccion_']").each(function(){
			//en el atributo name tenemos el nombre del campo
			var nombre = $(this).attr("name").replace("campo_direccion_", "") + "[]";
			//var nombre = $(this).attr("name").split("campo_direccion_")[0];
			var valor = $(this).val();
			formParams += "&" + nombre + "=" + valor;
		});
		var parametros = "codigo=" + codigo + "&cliente=" + cliente;
		parametros += formParams;

		//Vamos a obtener el fichero "perso" que tenemos que utilizar:
		elementos_comunes = $("div[reference^=codigo_" + codigo);
		total_elementos = new Array();
		elementos_comunes.each(function(){
			//vamos a obtener la personalización a partir del ID
			var id = $(this).attr("reference");
			//console.log(id);
			//Ahora vamos a dividir el id en un array a partir de los guiones:
			id = id.split("_");	//==>Separamos la cadena en un array
			id = id.slice(3);	//==> Cortamos del tercer elemento en adelante
			id = id.join("_");	//==> Juntamos el array resultante para obtener una cadena
			//Si el ID obtenido no está en el array de elementos, entonces hay que añadirlo
			if (total_elementos.indexOf(id) == -1){
				total_elementos.push(id);
			}
		});
		//en "total elementos" debemos tener un array con las clases a utilizar. Hay de pasarlo como parámetro
		total_elementos = total_elementos.join("<" + "." + "." + ">");
		parametros += "&lista_ficheros_perso=" + total_elementos;
		parametros += "&accion=" + accion;
		var url = shopUrl + "comunes/consultas/crea_mod_direccion_envio.php";
		//console.log(parametros);
		//console.log(url, parametros);
		realizar_solicitud(url, parametros, function(respuesta){
			//Vamos a procesar la respuesta:
			//console.log("-" + respuesta + "-");
			respuesta = respuesta.split("*" + "@" + "." + "@" + "*");
			for (var counter = 0; counter < respuesta.length; counter++){
				var codigo_html = respuesta[counter].split("@" + "*" + "." + "*" + "@");
				if (codigo_html.length > 0){
					//El el valor 0 tengo el código y el nombre del estilo separados por un | (pipe)
					var cadena_aux = codigo_html[0].split("|" + "-" + "-" + "|");
					var codigo = cadena_aux[0];
					//console.log(codigo);
					var tipo_fichero = cadena_aux[1];
					//console.log(tipo_fichero);
					//ahora vamos a crear un objeto nuevo:
					//console.log(codigo_html[1]);
					//Antes de asignar la dirección y esas cosas, vamos a mostrar/ocultar lo que haya que mostrar/ocultar
					//traduccion
					$(".mensaje_aviso").html('Dirección modificada satisfactoriamente');
					window.setTimeout(function(){
						$(".mensaje_aviso").hide('slow');
					}, 3000);
					$(".mensaje_aviso").show();
					//Una vez modificada la direccion cambiarmos los botones y añadimos la propiedad readonly a los campos
					formulario.find('.guardar_modificaciones_direccion_envio').hide('fast');
					formulario.find("input[type='text']").prop('readonly', true);
					formulario.find("textarea").prop('readonly', true);
					//formulario.find('input[type="button"]').prop('disabled', true);
					formulario.find('.botones_mod_borrar_direccion_envio').show('fast');
					$("div[reference^='codigo_" + codigo + "'][reference$='" + tipo_fichero + "']").each(function(){
						//console.log($(this));
						var nuevo_elemento = $(codigo_html[1]);
						$(this).html(nuevo_elemento.html());
						//$(this).before( $(codigo_html[1]) );

					});
					//$("div[reference^='codigo_" + codigo + "'][reference$='" + tipo_fichero + "']").html(codigo_html[1]);
				}
			}
		});
	}
}
function cloneCampo(elementObjetive) {
    var boton = elementObjetive.prev();
    var existBoton = false;
    if (boton.hasClass('boton')) {
        var campoMolde = boton.prev();
        boton = boton.clone();
        existBoton = true;
    } else {
        var campoMolde = elementObjetive.prev();
        boton = elementObjetive.clone();
        boton.val('-');
        boton.attr('onclick','deleteCampo($(this))');
    }
    var campo = campoMolde.clone();
    if (campo.children().length != 0) {
        campo.find("input[type='text']").each(function () {
            $(this).val('');
        });
        campo.find("textarea").each(function () {
            $(this).text('');
        });
    } else {
        campo.val('');
    }
        elementObjetive.before(campo);
        elementObjetive.before(boton);

}
function deleteCampo(elemento) {
    elemento.prev().remove();
    elemento.remove();
}